<?php
/**
 * @package WordPress
 * @subpackage Wpthematic
 */
 // Coordination functions
  include (TEMPLATEPATH .'/coordination_functions/functions.php');
  
 // Widgets
 require_once dirname( __FILE__ ) . '/inc/social-profil.php';
 
 function Wpthematic_scripts() {
// Add Genericons font, used in the main stylesheet.
	wp_enqueue_style( 'genericons', get_template_directory_uri() . '/admin/genericons/genericons.css', array(), '3.0.2' );

	// Load our main stylesheet.
	wp_enqueue_style( 'wpthematic-style', get_stylesheet_uri(), array( 'genericons' ) );
}
add_action( 'wp_enqueue_scripts', 'Wpthematic_scripts' );
// search form html5
add_theme_support('html5', array('search-form'));	
// Option du thème

if ( !function_exists( 'optionsframework_init' ) ) {
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/admin/' );
	require_once dirname( __FILE__ ) . '/admin/options-framework.php';
}

 include (TEMPLATEPATH .'/options.php');
 // widget video
//include (TEMPLATEPATH .'/widget/wd_video.php');
add_theme_support( 'automatic-feed-links' );
require_once dirname( __FILE__ ) . '/admin/custom-post-templates.php';



if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	
	register_sidebar(array(
		'name' => __( 'Sidebar 1' ),
		'id' => 'sidebar-1',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	
	register_sidebar(array(
		'name' => __( 'Sidebar 2' ),
		'id' => 'sidebar-2',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	
	register_sidebar(array(
		'name' => __( 'Sidebar 3' ),
		'id' => 'sidebar-3',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h4 class="widgettitle">',
		'after_title' => '</h4>',
	));
	
	// Area 3, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Première Zone Widget Footer' ),
		'id' => 'first-footer-widget-area',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title-footer">',
		'after_title' => '</h3>',
	) );

	// Area 4, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Deuxième Zone Widget Footer' ),
		'id' => 'second-footer-widget-area',
		'description' => __( 'Ajouter vos widget ici' ),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title-footer">',
		'after_title' => '</h3>',
	) );

	// Area 5, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Troisième Zone Widget Footer' ),
		'id' => 'third-footer-widget-area',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title-footer">',
		'after_title' => '</h3>',
	) );

	// Area 6, located in the footer. Empty by default.
	register_sidebar( array(
		'name' => __( 'Quatrième Zone Widget Footer' ),
		'id' => 'fourth-footer-widget-area',
		'description' => __( 'Ajouter vos widget ici'),
		'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h3 class="widget-title-footer">',
		'after_title' => '</h3>',
	) );
}

// This theme uses Featured Images (also known as post thumbnails) for per-post/per-page Custom Header images
	add_theme_support( 'post-thumbnails' );
	

// Create a function for register_nav_menus()
function add_wp3menu_support() {
 
register_nav_menus(
        array(
        'main-menu' => __('Premier Menu')
        
        )
     );
 
}
 

add_action('init', 'add_wp3menu_support');
//Add link home menu 1.

add_filter('wp_nav_menu_items','home_menu_1_function', 10, 2);
function home_menu_1_function( $items, $args ) {
    if( $args->theme_location == 'main-menu' )
	
        $homeMenuItem =
                '<li class="menu-1">' .
                $args->before .
                '<a href="' . home_url( '/' ) . '" title="Home">' .
                $args->link_before . '<div class="home-icon"></div>' . $args->link_after .
                '</a>' .
                $args->after .
                '</li>';
  
        $items = $homeMenuItem . $items;
  
    return $items;
}
// Search form Html5
function html5_search_form( $form ) {
    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <input type="search" class="search-form" type="search" placeholder="'.__("Rechercher...").'" value="' . get_search_query() . '" name="s" id="s" />
    </form>';

    return $form;
}
add_filter( 'get_search_form', 'html5_search_form' );// class post nav link
function add_class_next_post_link($html){
    $html = str_replace('<a','<a class="styled-button"',$html);
    return $html;
}
add_filter('next_post_link','add_class_next_post_link',10,1);
function add_class_previous_post_link($html){
    $html = str_replace('<a','<a class="styled-button"',$html);
    return $html;
}
add_filter('previous_post_link','add_class_previous_post_link',10,1);

// fonction image

function sp_resize( $url, $width, $height = null, $crop = null, $single = true ) {

	//validate inputs
	if(!$url OR !$width ) return false;

	//define upload path & dir
	$upload_info = wp_upload_dir();
	$upload_dir = $upload_info['basedir'];
	$upload_url = $upload_info['baseurl'];

	//check if $img_url is local
	if(strpos( $url, $upload_url ) === false) return false;

	//define path of image
	$rel_path = str_replace( $upload_url, '', $url);
	$img_path = $upload_dir . $rel_path;

	//check if img path exists, and is an image indeed
	if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;

	//get image info
	$info = pathinfo($img_path);
	$ext = $info['extension'];
	list($orig_w,$orig_h) = getimagesize($img_path);

	//get image size after cropping
	$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
	$dst_w = $dims[4];
	$dst_h = $dims[5];

	//use this to check if cropped image already exists, so we can return that instead
	$suffix = "{$dst_w}x{$dst_h}";
	$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
	$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";

	//if orig size is smaller
	if($width >= $orig_w) {

		if(!$dst_h) :
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;

		else :
			//else check if cache exists
			if(file_exists($destfilename) && getimagesize($destfilename)) {
				$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
			} 
			//else resize and return the new resized image url
			else {
				$resized_img_path = image_resize( $img_path, $width, $height, $crop );
				$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
				$img_url = $upload_url . $resized_rel_path;
			}

		endif;

	}
	//else check if cache exists
	elseif(file_exists($destfilename) && getimagesize($destfilename)) {
		$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
	} 
	//else, we resize the image and return the new resized image url
	else {
		$resized_img_path = image_resize( $img_path, $width, $height, $crop );
		$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
		$img_url = $upload_url . $resized_rel_path;
	}

	//return the output
	if($single) {
		//str return
		$image = $img_url;
	} else {
		//array return
		$image = array (
			0 => $img_url,
			1 => $dst_w,
			2 => $dst_h
		);
	}

	return $image;
}
// fonction extrait
function excerpt($limit) {
      $excerpt = explode(' ', get_the_excerpt(), $limit);
      if (count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).'';
      } else {
        $excerpt = implode(" ",$excerpt);
      } 
      $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
      return $excerpt;
    }
// pignation
function naxialis_pagination($pages = '', $range = 1)
{  
     $showitems = ($range * 2)-1;  

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   

     if(1 != $pages)
     {
         echo "<div class='pagination-pages'>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
         echo "</div>\n";
     }
}

// pignation fin
// Gallerie photo class
function my_get_attachment_link($html) { $postid = get_the_ID(); $html = str_replace('<a', '<a rel="prettyPhoto[pp_gal]"', $html); return $html; } add_filter('wp_get_attachment_link', 'my_get_attachment_link', 10, 1);
function insert_colorbox_rel($content) {
	$pattern = '/<a(.*?)href="(.*?).(bmp|gif|jpeg|jpg|png)"(.*?)>/i';
  	$replacement = '<a$1href="$2.$3" rel=\'prettyPhoto\'$4>';
	$content = preg_replace( $pattern, $replacement, $content );
	return $content;
}
add_filter( 'the_content', 'insert_colorbox_rel' );

set_post_thumbnail_size( 200, 125, true ); // hard crop mode true
 
//------enable post thumbnail preview for custom columns 
if ( !function_exists('fb_AddThumbColumn') && function_exists('add_theme_support') ) {
 
	// for post and investments
 
	function fb_AddThumbColumn($cols) { 
		$cols['thumbnail'] = __('Thumbnail'); 
		return $cols;
	}
 
	function fb_AddThumbValue($column_name, $post_id) {
 
			$width = (int) 200;
			$height = (int) 125;
 
 
			if ( 'thumbnail' == $column_name ) {
				// thumbnail of WP 2.9
				$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
				// image from gallery
				$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );
				if ($thumbnail_id)
					$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
				elseif ($attachments) {
					foreach ( $attachments as $attachment_id => $attachment ) {
						$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
					}
				}
					if ( isset($thumb) && $thumb ) {
						echo $thumb;
					} else {
						echo __('Aucune Image');
					}
			}
	}
 
	// for posts
	add_filter( 'manage_posts_columns', 'fb_AddThumbColumn' );
	add_action( 'manage_posts_custom_column', 'fb_AddThumbValue', 10, 2 );
 
	// for investments
	add_filter( 'manage_investments_columns', 'fb_AddThumbColumn' );
	add_action( 'manage_investments_custom_column', 'fb_AddThumbValue', 10, 2 );
}

add_action( 'manage_posts_custom_column', 'my_column_action', 10, 1 );
function my_column_action( $column ) {
	global $post;
	switch ( $column ) {
		case 'wordcount':
			echo str_word_count( $post->post_content );
			break;
	}
}
add_filter( 'manage_edit-post_columns', 'my_columns_filter', 10, 1 );
function my_columns_filter( $columns ) {
	$column_wordcount = array( 'wordcount' => 'Nombre de Mots' );
	$columns = array_slice( $columns, 0, 3, true ) + $column_wordcount + array_slice( $columns, 3, NULL, true );
	return $columns;
}
// fin
// gallerie css
add_filter('gallery_style',
	create_function(
		'$css',
		'return preg_replace("#<style type=\'text/css\'>(.*?)</style>#s", "", $css);'
		)
	);
// image attachemetn gallry

$prefix = 'gallery_';
$align_gallery = array("float:right;" => "A droite","margin:0 auto;" => "Au centre","float:left;" => "A gauche");
$meta_box_gallery = array(
	'id' => 'gallery-meta-box',
	'title' => 'Param&egrave;tre de la gallerie wordpress',
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'low',
	'fields' => array(
		array(
			'name' => 'Taille des Vignettes',
			'desc' => 'Entrer la taille des vignettes en px(<em>exemple: 150px</em>), la hauteur et largeur sont proportionnelle.',
			'id' => $prefix . 'size',
			'type' => 'text',
			'std' => '150px'
		),
		array(
			'name' => 'Largeur de la galerie',
			'desc' => 'Entrer la lageur de votre gallerie en px(<em>exemple : 450px</em>).',
			'id' => $prefix . 'width',
			'type' => 'text',
			'std' => '670px'
		),
		array(
			'name' => 'Alignement de la galerie',
			'id' => $prefix . 'align',
			'type' => 'select',
			'options' => $align_gallery
		),
		
	)
);

add_action('admin_menu', 'gallery_add_box');

// Add meta box
function gallery_add_box() {
	global $meta_box_gallery;
	
	add_meta_box($meta_box_gallery['id'], $meta_box_gallery['title'], 'gallery_show_box', $meta_box_gallery['page'], $meta_box_gallery['context'], $meta_box_gallery['priority']);
	add_meta_box($meta_box_gallery['id'], $meta_box_gallery['title'], 'gallery_show_box', 'page', $meta_box_gallery['context'], $meta_box_gallery['priority']);
	
}

// Callback function to show fields in meta box
function gallery_show_box() {
	global $meta_box_gallery, $post;
	
	// Use nonce for verification
	echo '<input type="hidden" name="mytheme_meta_box_nonce" value="', wp_create_nonce(basename(__FILE__)), '" />';
	
	echo '<table class="form-table">';

	foreach ($meta_box_gallery['fields'] as $field) {
		// get current post meta data
		$meta = get_post_meta($post->ID, $field['id'], true);
		
		echo '<tr>',
				'<th style="width:20%"><label for="', $field['id'], '">', $field['name'], '</label></th>',
				'<td>';
		switch ($field['type']) {
			case 'text':
				echo '<input type="text" name="', $field['id'], '" id="', $field['id'], '" value="', $meta ? $meta : $field['std'], '" size="30" style="width:40%" />',
					'<br />', $field['desc'];
				break;
			case 'textarea':
				echo '<textarea name="', $field['id'], '" id="', $field['id'], '" cols="60" rows="4" style="width:97%">', $meta ? $meta : $field['std'], '</textarea>',
					'<br />', $field['desc'];
				break;
			case 'select':
				echo '<select name="', $field['id'], '" id="', $field['id'], '">';
				foreach ($field['options'] as $option) {
					echo '<option', $meta == $option ? ' selected="selected"' : '', '>', $option, '</option>';
				}
				echo '</select>';
				break;
			case 'radio':
				foreach ($field['options'] as $option) {
					echo '<input type="radio" name="', $field['id'], '" value="', $option['value'], '"', $meta == $option['value'] ? ' checked="checked"' : '', ' />', $option['name'];
				}
				break;
			case 'checkbox':
				echo '<input type="checkbox" name="', $field['id'], '" id="', $field['id'], '"', $meta ? ' checked="checked"' : '', ' />',
				'<br />', $field['desc'];
				break;
		}
		echo 	'<td>',
			'</tr>';
	}
	
	echo '</table>';
	echo '</br>';
	echo" ";
	
}

add_action('save_post', 'gallery_save_data');

// Save data from meta box
function gallery_save_data($post_id) {
	global $meta_box_gallery;
	
	// verify nonce
	if (!wp_verify_nonce($_POST['mytheme_meta_box_nonce'], basename(__FILE__))) {
		return $post_id;
	}

	// check autosave
	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
		return $post_id;
	}

	// check permissions
	if ('page' == $_POST['post_type']) {
		if (!current_user_can('edit_page', $post_id)) {
			return $post_id;
		}
	} elseif (!current_user_can('edit_post', $post_id)) {
		return $post_id;
	}
	
	foreach ($meta_box_gallery['fields'] as $field) {
		$old = get_post_meta($post_id, $field['id'], true);
		$new = $_POST[$field['id']];
		
		if ($new && $new != $old) {
			update_post_meta($post_id, $field['id'], $new);
		} elseif ('' == $new && $old) {
			delete_post_meta($post_id, $field['id'], $old);
		}
	}
}
add_filter( 'the_content', 'remove_br_gallery', 11, 2);
function remove_br_gallery($output) {
    return preg_replace('/<br style=(.*)>/mi','',$output);
}

// pagnation
function wpthematic_pagination($pages = '', $range = 1)
{  
     $showitems = ($range * 2)-1;  

     global $paged;
     if(empty($paged)) $paged = 1;

     if($pages == '')
     {
         global $wp_query;
         $pages = $wp_query->max_num_pages;
         if(!$pages)
         {
             $pages = 1;
         }
     }   

     if(1 != $pages)
     {
         echo "<div class='pagination-pages'>";
         if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo;</a>";
         if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

         for ($i=1; $i <= $pages; $i++)
         {
             if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
             {
                 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
             }
         }

         if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";  
         if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>&raquo;</a>";
         echo "</div>\n";
     }
}

// pagnation fin

class WP_Widget_Recent_Comments_Excerpts extends WP_Widget {

	function WP_Widget_Recent_Comments_Excerpts() {
		$widget_ops = array('classname' => 'widget_recent_comments', 'description' => __( 'The most recent comments' ) );
		$this->WP_Widget('recent-comments', __('Recent Comments'), $widget_ops);
		$this->alt_option_name = 'widget_recent_comments';

		if ( is_active_widget(false, false, $this->id_base) )
			add_action( 'wp_head', array(&$this, 'recent_comments_style') );

		add_action( 'comment_post', array(&$this, 'flush_widget_cache') );
		add_action( 'transition_comment_status', array(&$this, 'flush_widget_cache') );
	}

	function recent_comments_style() { ?>
	<style type="text/css">.recentcomments a{display:inline !important;padding:0 !important;margin:0 !important;}</style>
<?php
	}

	function flush_widget_cache() {
		wp_cache_delete('recent_comments', 'widget');
	}

	function widget( $args, $instance ) {
		global $wpdb, $comments, $comment;

		extract($args, EXTR_SKIP);
		$title = apply_filters('widget_title', empty($instance['title']) ? __('Recent Comments') : $instance['title']);
		if ( !$number = (int) $instance['number'] )
			$number = 5;
		else if ( $number < 1 )
			$number = 1;
		else if ( $number > 15 )
			$number = 15;

		if ( !$comments = wp_cache_get( 'recent_comments', 'widget' ) ) {
			$comments = $wpdb->get_results("SELECT $wpdb->comments.* FROM $wpdb->comments JOIN $wpdb->posts ON $wpdb->posts.ID = $wpdb->comments.comment_post_ID WHERE comment_approved = '1' AND post_status = 'publish' ORDER BY comment_date_gmt DESC LIMIT 15");
			wp_cache_add( 'recent_comments', $comments, 'widget' );
		}

		$comments = array_slice( (array) $comments, 0, $number );
?>
		<?php echo $before_widget; ?>
			<?php if ( $title ) echo $before_title . $title . $after_title; ?>
			<ul id="recentcomments"><?php
			if ( $comments ) : foreach ( (array) $comments as $comment) :
			//echo  '<li class="recentcomments">' . /* translators: comments widget: 1: comment author, 2: post link */ sprintf(_x('%1$s on %2$s', 'widgets'), get_comment_author_link(), '<a href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">' . get_the_title($comment->comment_post_ID) . '</a>') . '</li>';
				$aRecentComment = get_comment($comment->comment_ID);
				$aRecentCommentTxt = trim( substr( $aRecentComment->comment_content, 0, 50 )) . "...";
			echo  '<li class="recentcomments">' . /* translators: comments widget: 1: comment author, 2: post link */ sprintf(_x('<strong>%1$s</strong> dit %2$s', 'widgets'), get_comment_author_link(), '<a href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">' . $aRecentCommentTxt . '</a>') . '<br/>Sur : <em>' . get_the_title($comment->comment_post_ID) . '</em></li>';
			endforeach; endif;?></ul>
		<?php echo $after_widget; ?>
<?php
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_comments']) )
			delete_option('widget_recent_comments');

		return $instance;
	}

	function form( $instance ) {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number = isset($instance['number']) ? absint($instance['number']) : 5;
?>
		<p><label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id('number'); ?>"><?php _e('Number of comments to show:'); ?></label>
		<input id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" size="3" /><br />
		<small><?php _e('(Max 15)'); ?></small></p>
<?php
	}
}

function WP_Widget_Recent_Comments_Excerpts_Init() {
	register_widget('WP_Widget_Recent_Comments_Excerpts');
}
add_action('widgets_init', 'WP_Widget_Recent_Comments_Excerpts_Init');

// Add  twitter/facebook
function the_share(){
global $post;
?>
<div class="twitt-fb">
 
<a href="http://twitter.com/share"
 
class="twitter-share-button"
 
data-count="horizontal">Tweet</a>
 
 <script type="text/javascript"
 
src="http://platform.twitter.com/widgets.js"></script>
 </div>
<div class="facebook-share-button">
 
 <iframe
 
src="http://www.facebook.com/plugins/like.php?href=<?php echo urlencode(get_permalink($post->ID)); ?>&layout=button_count&show_faces=false&width=200&action=like&colorscheme=light&height=21"
 
scrolling="no" frameborder="0" style="border:none;
 
overflow:hidden; width:90px; height:21px;"
 
allowTransparency="true"></iframe>
 
 </div>
          <div id="fb-root">
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) {return;}
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/fr_FR/all.js#xfbml=1";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
<div class="fb-send" data-href="<?php echo urlencode(get_permalink($post->ID)); ?>"></div>
</div>
 <div class="g-plus">
<g:plusone size="medium"></g:plusone>
<script type="text/javascript">gapi.plusone.go();</script>
 </div>
 
<?php } ?>
<?php
// share +
function the_share_plus(){
global $post;
?>
<div id="button">
<img src="<?php bloginfo('template_url'); ?>/images/button.png" width="45" height="25" class="menu_class" />
<ul class="the_menu">
<br />
<li class="digg"><a href="http://digg.com/submit?phase=2&amp;url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Digg" target="_blank">Partager sur Digg</a></li>
<br />
<li class="delicious"><a href="http://del.icio.us/post?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Delicious." target="_blank">Partager sur Delicious</a></li>
<br />
<li class="in"><a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Linkedin" target="_blank">Partager sur Linkedin</a></li>
<br />
<li class="reddit"><a href="http://reddit.com/submit?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="Partager sur Reddit" target="_blank">Partager sur Reddit</a></li>
<br />
</ul>
</div>
 
<?php } ?>