<?php
/**
 * Plugin Name: Widget inscription
 * Plugin URI: 
 * Description: 
 * Version: 0.1
 * Author: naxialis
 * Author URI: 
 *
 */

/**
 * Add function to widgets_init that'll load our widget.
 * @since 0.1
 */
add_action( 'widgets_init', 'incription_load_widgets' );

/**
 * Register our widget.
 * 'prevention_Widget' is the widget class used below.
 *
 * @since 0.1
 */
function incription_load_widgets() {
	register_widget( 'prevention_Widget' );
}

/**
 * Example Widget class.
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 * @since 0.1
 */
class prevention_Widget extends WP_Widget {

	/**
	 * Widget setup.
	 */
	function prevention_Widget() {
		/* Widget settings. */
		$widget_ops = array( 'classname' => 'inscription_prevention', 'description' => __('Affiche le bouton inscription.', 'inscription_prevention') );

		/* Widget control settings. */
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'prevention-widget' );

		/* Create the widget. */
		$this->WP_Widget( 'prevention-widget', __('Inscription la prevention', 'inscription_prevention'), $widget_ops, $control_ops );
	}

	/**
	 * How to display the widget on the screen.
	 */
	function widget( $args, $instance ) {
		extract( $args );

		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$lien_info = $instance['lien_info'];
		$lien_img_info = $instance['lien_img_info'];
		$lien_img = $instance['lien_img'];
		

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;

		/* Display name from widget settings if one was input. */
		?>
        <ul class="sign-prevention">
  <a href="http://lacoordination.be/inscriptions/"><img class="sign-insc" src=" <?php echo  $lien_img ; ?> "/></a>
  <a href="<?php echo  $lien_info ; ?>"><img class="sign-info" src=" <?php echo  $lien_img_info ; ?> "/></a>
</ul>
        <?php
		/* After widget (defined by themes). */
		echo $after_widget;
	}

	/**
	 * Update the widget settings.
	 */
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		/* Strip tags for title and name to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['lien_info'] = strip_tags( $new_instance['lien_info'] );
		$instance['lien_img'] = strip_tags( $new_instance['lien_img'] ) ;
		$instance['lien_img_info'] = strip_tags( $new_instance['lien_img_info'] ) ;

		return $instance;
	}

	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array( 'title' => __('S&acute;inscrire sur la pr&eacute;vention.be', 'inscription_prevention') );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Titre du widget:', 'hybrid'); ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'lien_img' ); ?>"><?php _e('Lien de l&acute;icon inscription :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'lien_img' ); ?>" name="<?php echo $this->get_field_name( 'lien_img' ); ?>" value="<?php echo $instance['lien_img']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'lien_img_info' ); ?>"><?php _e('Lien de l&acute;icon conditions :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'lien_img_info' ); ?>" name="<?php echo $this->get_field_name( 'lien_img_info' ); ?>" value="<?php echo $instance['lien_img_info']; ?>" style="width:100%;" />
            <label for="<?php echo $this->get_field_id( 'lien_info' ); ?>"><?php _e('Lien de la page conditions :', 'hybrid'); ?></label>
            <input id="<?php echo $this->get_field_id( 'lien_info' ); ?>" name="<?php echo $this->get_field_name( 'lien_info' ); ?>" value="<?php echo $instance['lien_info']; ?>" style="width:100%;" />
		</p>


	<?php
	}
}

?>