<?php
/** post vertical 2 block **/
class AQ_post_vertical_2_Block extends AQ_Block {
	
	//set and create block
	function __construct() {
		$block_options = array(
			'name' => 'Articles Verticale',
			'size' => 'span12',
		);
		
		//create the block
		parent::__construct('aq_post_vertical_2_Block', $block_options);
	}
	
	function form($instance) {
		
		$colonnes_options = array(
			'3' => '250px - 150px',
			'4' => '200px - 100px',
			'5' => '150px - 150px ',
			'6' => 'Personalisé ',
			
		);
		
		$defaults = array(
			'excerpth1' => '30',
			'number_post' => '4',
			'img_height' => '120',
			'img_width' => '200',
		);
		$instance = wp_parse_args($instance, $defaults);
		extract($instance);
		$block_color = isset($block_color) ? $block_color : '#353535';
		$block_color = isset($block_color) ? $block_color : '#353535';
		$title_fonts_color = isset($title_fonts_color) ? $title_fonts_color : '#ffffff';
		?>
        <p class="description">
			<label for="<?php echo $this->get_field_id('title') ?>">
				Titre du bloc des articles
				<?php echo aq_field_input('title', $block_id, $title, $size = 'full') ?>
			</label>
		</p>
        <div class="description">
			<label for="<?php echo $this->get_field_id('block_color') ?>">
				Couleur de fond pour le block
				<?php echo aq_field_color_picker('block_color', $block_id, $block_color, $defaults['block_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('title_fonts_color') ?>">
				Couleur du titre<br/>
				<?php echo aq_field_color_picker('title_fonts_color', $block_id, $title_fonts_color, $defaults['title_fonts_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('texte_color') ?>">
				Couleur du texte<br/>
				<?php echo aq_field_color_picker('texte_color', $block_id, $texte_color, $defaults['texte_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('alink_color') ?>">
				Couleur des liens (a)<br/>
				<?php echo aq_field_color_picker('alink_color', $block_id, $alink_color, $defaults['alink_color']) ?>
			</label>
            
            <label for="<?php echo $this->get_field_id('hoverlink_color') ?>">
				Couleur des liens (hover)<br/>
				<?php echo aq_field_color_picker('hoverlink_color', $block_id, $hoverlink_color, $defaults['hoverlink_color']) ?>
			</label>
			
		</div>
		<p class="description">
        <h4>Paramètre des articles</h4>
			<label for="<?php echo $this->get_field_id('number_post') ?>">
				<div style="width:200px; float:left;">Nombre d'articles</div>
				<?php echo aq_field_input('number_post', $block_id, $number_post, $size = 'min') ?>
			</label>
            <br />
			<label for="<?php echo $this->get_field_id('excerpth1') ?>">
				<div style="width:200px; float:left;">Longueur des extraits</div>
				<?php echo aq_field_input('excerpth1', $block_id, $excerpth1, $size = 'min') ?>
			</label>
            <br />
            <label for="<?php echo $this->get_field_id('id_post') ?>">
				<div style="width:200px; float:left;">Identifiant</div>
				<?php echo aq_field_input('id_post', $block_id, $id_post, $size = 'min') ?>
			</label>
            <br />
            <h4>Images des articles</h4>
			<label for="<?php echo $this->get_field_id('post_colonnes') ?>">
				Choisissez la taille de l'images des articles.<br/>
				<div style="width:250px;"><?php echo aq_field_select('post_colonnes', $block_id, $colonnes_options, $post_colonnes, $block_id); ?></div>
			</label>
			<br />
            <label for="<?php echo $this->get_field_id('width_post_image') ?>">
				<div style="width:200px; float:left;">Largeur</div>
				<?php echo aq_field_input('width_post_image', $block_id, $width_post_image, $size = 'min') ?>
			</label>
            <br />
            <label for="<?php echo $this->get_field_id('height_post_image') ?>">
				<div style="width:200px; float:left;">Hauteur</div>
				<?php echo aq_field_input('height_post_image', $block_id, $height_post_image, $size = 'min') ?>
			</label>
		<p class="description">
        <label><?php _e( 'Categorie' ); ?>:</label>
		<?php wp_dropdown_categories( array( 'show_option_all' => __('ALL'),'hide_empty'  => 0,'name' => $this->get_field_name("cat_posts"), 'selected' => $instance["cat_posts"] ) ); ?>
        	</p>
            
         <div class="clear-block"></div>
         <p class="description">
        <div style="width:250px; float:left;"><label><?php _e( 'Afficher le titre des articles' ); ?>:</label></div>
		<?php echo aq_field_checkbox ('title_post_display', $block_id, $title_post_display,$check) ?>
        	</p>
           
          <p class="description">
           <h4>Post meta</h4>
        <div style="width:250px; float:left;"><label><?php _e( 'Afficher la date' ); ?>:</label></div>
		<?php echo aq_field_checkbox ('date_post_display', $block_id, $date_post_display,$check) ?>
        <br/><br/>
        <div style="width:250px; float:left;"><label><?php _e( 'Afficher le nombre de commentaire' ); ?>:</label></div>
		<?php echo aq_field_checkbox ('comment_post_display', $block_id, $comment_post_display,$check) ?>
        <br/><br/>
        <div style="width:250px; float:left;"><label><?php _e( "Afficher la catégorie de l'article" ); ?>:</label></div>
		<?php echo aq_field_checkbox ('cat_post_display', $block_id, $cat_post_display,$check) ?>
        <br/>
        	</p>
			
		
		
		<?php
	}
	
	function block($instance) {
		extract($instance);
		echo '<style>
				
				.link_'.$id_post.' a {
					color: '.$alink_color.';
				}
				
				.link_'.$id_post.' a:hover {
					color: '.$hoverlink_color.';
				}
		
			  </style>';
		
		echo '<div style="background-color:'.$block_color.'; color:'.$texte_color.'; padding:10px;" id="row-fix" class="vertical-post link_'.$id_post.'">';
		echo '<h2 class="title-video" style="color:'.$title_fonts_color.';"><span>'.$title.'</h2>';
		$args= array(
			'showposts' => $number_post,
			'cat' => $cat_posts
			);
			
$the_query = new WP_Query($args);
while ($the_query->have_posts()) : $the_query->the_post();

if (has_post_thumbnail()) { ?>

<?php               
                        switch($post_colonnes) {
			
			case '3':
				$thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, 250, 150, true );
				break;
			case '4':
				$thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, 200, 100, true );
				echo '';
				break;
			case '5':
				$thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, 150, 150, true );
				break;
			case '6':
				$thumb = get_post_thumbnail_id(); $img_url = wp_get_attachment_url( $thumb,'full' ); $image = sp_resize( $img_url, $width_post_image, $height_post_image, true );
				break;
		}
                ?>
<a href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><img src="<?php echo $image ?>" border="0"/></a>  
<?php  } else { } 

  	   // Votre boucle 
?>
  <?php if($title_post_display) { ?>
							 <h4><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h4>
                            <?php } else { }?>
    <div class="post-meta-view">
                            <?php if($date_post_display) { ?>
                            <span class="calendar"><?php echo get_the_date(); ?></span>
                            <?php } else { }?>
                             <?php if($comment_post_display) { ?>
                            <span class="comments"><?php comments_number( '0', '1', '%' ); ?></span>
                            <?php } else { }?>
                            <?php if($cat_post_display) { ?>
                            <span class="tags"><?php the_category(', ') ?></span>
                            <?php } else { }?>
                            </div>
  <p><?php echo excerpt($excerpth1);?></p>

  <div id="verticalpost-spacer" class="clear"></div>
<?php //boucle fin
endwhile;
 wp_reset_query();
		
		echo'</div>';
		
		
	}
	
}